/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.steamer;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.pot.steamer.SteamerBlockEntity;
import dev.xkmc.youkaishomecoming.content.pot.steamer.SteamingRecipe;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class RackItemData {
    @SerialClass.SerialField
    public ItemStack stack = ItemStack.f_41583_;
    @SerialClass.SerialField
    @Nullable
    public ResourceLocation id;
    @SerialClass.SerialField
    public double progress;
    private boolean dirty = true;
    @Nullable
    private SteamingRecipe cache = null;

    public boolean tick(SteamerBlockEntity be, Level level, double heat) {
        this.updateRecipe(level);
        if (this.cache != null) {
            this.progress += heat;
            if (this.progress >= (double)this.cache.m_43753_()) {
                SimpleContainer cont = new SimpleContainer(1);
                cont.m_6836_(0, this.stack);
                this.setStack(be, this.cache.m_5874_((Container)cont, level.m_9598_()));
                this.id = null;
                this.cache = null;
                this.progress = 0.0;
            }
            return true;
        }
        return false;
    }

    public void setStack(SteamerBlockEntity be, ItemStack stack) {
        this.stack = stack;
        be.notifyTile();
        this.setChanged();
    }

    public void setChanged() {
        this.dirty = true;
    }

    private void updateRecipe(Level level) {
        Optional recipe;
        if (!this.dirty) {
            if (this.id == null) {
                this.cache = null;
                this.progress = 0.0;
                return;
            }
            if (this.cache != null) {
                return;
            }
        }
        this.dirty = false;
        if (this.stack.m_41619_()) {
            recipe = Optional.empty();
        } else {
            SimpleContainer cont = new SimpleContainer(1);
            cont.m_6836_(0, this.stack);
            recipe = level.m_7465_().m_44015_((RecipeType)YHBlocks.STEAM_RT.get(), (Container)cont, level);
        }
        if (this.id == null && recipe.isEmpty()) {
            this.progress = 0.0;
        } else if (recipe.isEmpty()) {
            this.id = null;
            this.progress = 0.0;
        } else if (!((SteamingRecipe)((Object)recipe.get())).m_6423_().equals((Object)this.id)) {
            this.id = ((SteamingRecipe)((Object)recipe.get())).m_6423_();
            this.progress = 0.0;
            this.cache = (SteamingRecipe)((Object)recipe.get());
        } else {
            this.cache = (SteamingRecipe)((Object)recipe.get());
        }
    }

    public boolean mayExtract() {
        return !this.stack.m_41619_() && this.id == null && !this.dirty;
    }
}

